// convert x3d
// m.miller 03.09.2023

//--- scale factor for sweep 
#declare sf=.85;


//--- u bracket
#declare part_A =  
sphere_sweep {
     cubic_spline
     13,
     <-4.500, 0.000, 2.679> , sf
     <-4.500, 0.000, 2.679> , sf
     <-4.500, 0.000, 0.014> , sf
     <-4.500, 0.000, -0.883> , sf
     <-4.084, 0.000, -1.885> , sf
     <-3.233, 0.000, -2.291> , sf
     <-0.010, 0.000, -2.291> , sf
     <3.126, 0.000, -2.291> , sf
     <4.119, 0.000, -1.876> , sf
     <4.500, 0.000, -0.893> , sf
     <4.500, 0.000, -0.023> , sf
     <4.500, 0.000, 2.688> , sf
     <4.500, 0.000, 2.688> , sf
     tolerance 0.000001
     }
             
             
//--- arm short         
#declare part_B =  
sphere_sweep {
     cubic_spline
     14,
     <-0.000, -3.600, -0.842> , sf
     <-0.000, -3.600, -0.842> , sf
     <-0.000, -1.672, -0.842> , sf
     <-0.000, 0.009, -0.842> , sf
     <-0.000, 0.951, -1.157> , sf
     <-0.000, 1.528, -1.864> , sf
     <-0.000, 1.672, -2.555> , sf
     <-0.000, 1.672, -11.572> , sf
     <-0.000, 1.876, -12.879> , sf
     <-0.000, 2.486, -13.880> , sf
     <-0.000, 4.131, -15.922> , sf
     <-0.000, 4.462, -16.413> , sf*1.1
     <-0.000, 4.896, -17.056> , sf*1.3
     <-0.000, 4.896, -17.056> , sf*1.5
     tolerance 0.000001
     }


//--- arm long         
#declare part_C =  
sphere_sweep {
     cubic_spline
     16,
     <-0.000, -3.600, -0.842> , sf
     <-0.000, -3.600, -0.842> , sf
     <-0.000, -1.672, -0.842> , sf
     <-0.000, 0.009, -0.842> , sf
     <-0.000, 0.951, -1.157> , sf
     <-0.000, 1.528, -1.864> , sf
     <-0.000, 1.672, -2.555> , sf 
     <-0.000, 1.672, -10.555> , sf  
     <-0.000, 1.672, -15.555> , sf
     <-0.000, 1.672, -21.572> , sf
     <-0.000, 1.876, -22.879> , sf
     <-0.000, 2.486, -23.880> , sf
     <-0.000, 4.131, -25.922> , sf
     <-0.000, 4.462, -26.413> , sf*1.1
     <-0.000, 4.896, -27.056> , sf*1.3
     <-0.000, 4.896, -27.056> , sf*1.5
     tolerance 0.000001
     }

//--- single hook
#declare part_D =
sphere_sweep {
     cubic_spline
     13,
     <0.004, 0.012, 2.820> , sf
     <0.004, 0.012, 2.820> , sf
     <0.004, 0.012, -0.748> , sf
     <0.004, -0.411, -1.741> , sf
     <0.004, -1.259, -2.152> , sf
     <0.004, -3.054, -2.152> , sf
     <0.004, -5.671, -2.152> , sf
     <0.004, -7.632, -2.152> , sf
     <0.004, -8.688, -2.742> , sf
     <0.004, -8.806, -3.947> , sf
     <0.004, -8.121, -4.680> , sf
     <0.004, -5.589, -6.884> , sf
     <0.004, -5.589, -6.884> , sf
     tolerance 0.000001
     }

//--- single screw driver rings
#declare part_E =
sphere_sweep {
     cubic_spline
     26,
     <-2.144, 0.000, -4.382> , sf
     <-2.144, 0.000, -4.382> , sf
     <-4.990, 0.000, -7.268> , sf
     <-5.045, 0.000, -11.296> , sf
     <-2.058, 0.000, -14.294> , sf
     <2.037, 0.000, -14.317> , sf
     <5.007, 0.000, -11.405> , sf
     <5.063, 0.000, -7.277> , sf
     <2.217, 0.000, -4.385> , sf
     <0.727, 0.000, -3.425> , sf
     <0.159, 0.000, -2.027> , sf
     <0.159, -0.680, -1.047> , sf
     <0.159, -2.014, -0.789> , sf
     <0.159, -20.549, -0.789> , sf
     <0.159, -21.480, -1.889> , sf
     <0.159, -21.565, -3.554> , sf
     <-2.098, -21.565, -4.429> , sf
     <-4.967, -21.565, -7.274> , sf
     <-5.061, -21.565, -11.249> , sf
     <-2.051, -21.565, -14.329> , sf
     <2.017, -21.565, -14.282> , sf
     <5.003, -21.565, -11.437> , sf
     <5.097, -21.565, -7.298> , sf
     <2.205, -21.565, -4.405> , sf
     <1.100, -21.565, -3.888> , sf
     <1.100, -21.565, -3.888> , sf
     tolerance 0.000001
     }

  //--- long support for 5 rings
#declare part_F =
sphere_sweep {
     cubic_spline
     22,                        
     <-40.498, 0.016, 2.800> , sf
     <-40.498, 0.016, 2.800> , sf                           
     <-40.498, 0.016, -0.753> , sf                          
     <-40.498, -0.418, -1.755> , sf                            
     <-40.498, -1.259, -2.152> , sf                             
     <-40.498, -3.064, -2.152> , sf                           
     <-40.498, -5.672, -2.152> , sf                            
     <-40.498, -7.638, -2.152> , sf
     <-40.103, -8.381, -2.152> , sf
     <-39.124, -8.830, -2.152> , sf
     <-22.399, -8.830, -2.152> , sf
     <22.399, -8.830, -2.152> , sf
     <39.124, -8.830, -2.152> , sf
     <40.103, -8.381, -2.152> , sf
     <40.498, -7.638, -2.152> , sf
     <40.498, -5.672, -2.152> , sf
     <40.498, -3.064, -2.152> , sf
     <40.498, -1.259, -2.152> , sf
     <40.498, -0.418, -1.755> , sf
     <40.498, 0.016, -0.753> , sf
     <40.498, 0.016, 2.800> , sf
     <40.498, 0.016, 2.800> , sf
     tolerance 0.000001
     }


  
             
#declare bracket_single_arm_short =
union {
    object { part_A }
    object { part_B }
    material{M_metal_chrome} 
    } 


#declare bracket_double_arm_short =
union {
    object { part_A }
    object { part_B translate <-3,0,0>}
    object { part_B translate <3,0,0>}
    material{M_metal_chrome} 
    } 
    

#declare bracket_single_arm_long =
union {
    object { part_A }
    object { part_C }
    material{M_metal_chrome} 
    }   

   
#declare bracket_double_arm_long =
union {
    object { part_A }
    object { part_C translate <-3,0,0>}
    object { part_C translate <3,0,0>}
    material{M_metal_chrome} 
    }  


#declare bracket_single_hook =
union {
    object { part_D }
    material{M_metal_chrome} 
    }  
    
    

    
    
#declare bracket_5_loops =
union {
    object { part_F }
    object { part_E translate <-36,0,-1.9>}
    object { part_E translate <-18,0,-1.9>}
    object { part_E translate <0,0,-1.9>}
    object { part_E translate <18,0,-1.9>}
    object { part_E translate <36,0,-1.9>}
    material{M_metal_chrome} 
    } 


    
//--- test objects    
#declare hardware =
union {
    object {bracket_single_arm_short    translate <-40,0,0>  }
    object {bracket_single_arm_long     translate <-20,0,0>  }
    object {bracket_double_arm_short    translate <0,0,0>    }
    object {bracket_double_arm_long     translate <20,0,0>   }
    object {bracket_single_hook         translate <40,0,0>   } 
    object {bracket_5_loops         translate <60,0,0>   }  
    rotate <0,-40,0>
} 

//hardware                         